/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import com.supermartijn642.rechiseled.chiseling.PacketChiselingRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChiselingRecipeLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)new ChiselingRecipeLoader());
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent e) {
        if (e.getPlayer() == null) {
            Rechiseled.CHANNEL.sendToAllPlayers((BasePacket)new PacketChiselingRecipes(ChiselingRecipes.getAllRecipes()));
        } else {
            Rechiseled.CHANNEL.sendToPlayer((Player)e.getPlayer(), (BasePacket)new PacketChiselingRecipes(ChiselingRecipes.getAllRecipes()));
        }
    }

    public ChiselingRecipeLoader() {
        super(GSON, "chiseling_recipes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> entries, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap recipes = Maps.newHashMap();
        ArrayList<ChiselingRecipe> recipesWithoutParent = new ArrayList<ChiselingRecipe>();
        ArrayList<ChiselingRecipe> recipesWithParent = new ArrayList<ChiselingRecipe>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : entries.entrySet()) {
            ChiselingRecipe recipe;
            ResourceLocation recipeId = entry.getKey();
            JsonObject json = entry.getValue().getAsJsonObject();
            try {
                recipe = ChiselingRecipe.Serializer.fromJson(entry.getKey(), json);
            }
            catch (Exception e) {
                System.err.println("Encountered an exception when trying to load chiseling recipe: " + recipeId);
                e.printStackTrace();
                continue;
            }
            recipes.put(recipeId, recipe);
            if (recipe.parentRecipeId == null) {
                recipesWithoutParent.add(recipe);
                continue;
            }
            recipesWithParent.add(recipe);
        }
        int successfullyLoadedRecipes = recipesWithoutParent.size();
        block3: for (ChiselingRecipe recipe : recipesWithParent) {
            HashSet<ResourceLocation> coveredRecipes = new HashSet<ResourceLocation>();
            List<ChiselingEntry> chiselingEntries = recipe.getEntries();
            ChiselingRecipe parentRecipe = recipe;
            while (parentRecipe.parentRecipeId != null) {
                coveredRecipes.add(parentRecipe.getRecipeId());
                ResourceLocation parentId = parentRecipe.parentRecipeId;
                if (coveredRecipes.contains(parentId)) {
                    System.err.println("Found circular parent references when trying to load chiseling recipe: " + recipe.getRecipeId());
                    continue block3;
                }
                parentRecipe = (ChiselingRecipe)recipes.get(parentId);
                if (parentRecipe != null) continue;
                System.err.println("Could not find parent '" + parentId + "' when trying to load chiseling recipe: " + recipe.getRecipeId());
                continue block3;
            }
            parentRecipe.addEntries(chiselingEntries);
            ++successfullyLoadedRecipes;
        }
        System.out.println("Loaded " + successfullyLoadedRecipes + " chiseling recipes");
        ChiselingRecipes.setRecipes(Collections.unmodifiableList(recipesWithoutParent));
    }
}

